#!/bin/sh
# /opt/Mahr/ps10/usb_gadget.sh
set -x

gadget_stop_mass_storage() {
    rmmod g_mass_storage
}

gadget_start_multi() {
    modprobe g_multi removable=1 idVendor=0x1d88 idProduct=0x0003 iSerialNumber=0x7073 iManufacturer="Mahr GmbH" iProduct="MarSurf PS10/M310/M410, GARANT ST2"
}

gadget_stop_multi() {
    rmmod g_multi
}

gadget_start_configfs() {
    CONFIGFS_HOME=/sys/kernel/config

    #mkdir -p $CONFIGFS_HOME
    modprobe libcomposite
    mount none $CONFIGFS_HOME -t configfs

    mkdir $CONFIGFS_HOME/usb_gadget/g1
    cd $CONFIGFS_HOME/usb_gadget/g1

    echo 0x1d88 > idVendor
    echo 0x0003 > idProduct

    mkdir strings/0x409
    echo "0x1234" > strings/0x409/serialnumber
    echo "Mahr GmbH" > strings/0x409/manufacturer
    echo "MarSurf PS10" > strings/0x409/product

    mkdir functions/mass_storage.0
    mkdir functions/acm.0
    mkdir functions/rndis.0

    # first and original configuration (mass-storage only)
    CFG1=c.1
    #mkdir configs/<name>.<number>
    mkdir configs/${CFG1}
    echo 500 > configs/${CFG1}/MaxPower
    mkdir configs/${CFG1}/strings/0x409
    echo "Conf 1" > configs/${CFG1}/strings/0x409/configuration

    ln -s functions/mass_storage.0 configs/${CFG1}

    # alternative configuration (rndis, cdc/acm, mass-storage)
    CFG2=c.2
    #mkdir configs/<name>.<number>
    mkdir configs/${CFG2}
    echo 500 > configs/${CFG2}/MaxPower
    mkdir configs/${CFG2}/strings/0x409
    echo "Conf 2" > configs/${CFG2}/strings/0x409/configuration

    # interfaces 0+1 (must be 0 for windows hosts)
    ln -s functions/rndis.0 configs/${CFG2}
    # interfaces 2+3
    ln -s functions/acm.0 configs/${CFG2}
    # interface 4
    ln -s functions/mass_storage.0 configs/${CFG2}

    # ls -lh /sys/class/udc/
    echo "musb-hdrc.0.auto" > UDC
}

gadget_stop_configfs() {
    CONFIGFS_HOME=/sys/kernel/config

    X=$(pwd)
    cd $CONFIGFS_HOME/usb_gadget/g1

    echo "" > UDC

    rm -rf configs/* > /dev/null 2>&1
    rm -rf functions/* > /dev/null 2>&1
    rm -rf strings/* > /dev/null 2>&1

    cd ..
    rmdir g1

    cd ${X}
    umount $CONFIGFS_HOME
}

USBINI=/var/opt/Mahr/ps10/usb.ini

# create usb.ini
if [ ! -e ${USBINI} ]; then
    echo "[device]" > ${USBINI}
    echo "gadget=multi" >> ${USBINI}
fi

GADGET=$(awk -F= '/^gadget/{printf $2}' ${USBINI})
ACTION=$1
BSFILE=/tmp/bs.file
BS=/tmp/bs.vfat
MUSB=/sys/bus/platform/drivers/musb-dsps
CURRENT_GADGET_MODE=/tmp/current_gadget_mode
echo "$0: GADGET=${GADGET}, ACTION=${ACTION}"

if [ "_${ACTION}" == "_start" ]; then
    if [ "_${GADGET}" == "_multi" ]; then
        gadget_start_multi
    elif [ "_${GADGET}" == "_mass_storage" ]; then
        echo "$0 gadget changed from mass_storage to multi before starting"
        GADGET=multi
        gadget_start_multi
    elif [ "_${GADGET}" == "_configfs" ]; then
        gadget_start_configfs
    fi
    echo ${GADGET} > ${CURRENT_GADGET_MODE}

    if [ -e ${BSFILE} ]; then
        echo ${BS} > $(cat ${BSFILE})
    fi

elif [ "_${ACTION}" == "_stop" ]; then
    GADGET=$(cat ${CURRENT_GADGET_MODE})
    if [ "_${GADGET}" == "_multi" ]; then
        gadget_stop_multi
    elif [ "_${GADGET}" == "_mass_storage" ]; then
        gadget_stop_mass_storage
    elif [ "_${GADGET}" == "_configfs" ]; then
        gadget_stop_configfs
    fi

elif [ "_${ACTION}" == "_bind" ]; then
    echo 47401400.usb > ${MUSB}/bind

elif [ "_${ACTION}" == "_unbind" ]; then
    echo 47401400.usb > ${MUSB}/unbind  
    usleep 100000 ## ???

else
    echo "$0: invalid parameter. needs start or stop"
    exit 1
fi

exit 0
